<?php
/**
 * Plugin Name:       SEO Yandex Assistant
 * Plugin URI:        https://rybinsklab.ru
 * Description:       Мощный SEO-плагин, оптимизированный для Яндекса. Управляет мета-тегами, анализирует контент и генерирует рекомендации с помощью DeepSeek AI.
 * Version:           1.0
 * Author:            Денис Усачёв
 * Author URI:        https://rybinsklab.ru/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       seo-yandex-assistant
 */

// Прямой доступ к файлу запрещен
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// --- 1. Константы для удобного доступа к путям ---
define( 'SYA_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'SYA_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// --- 2. Подключение всех модулей плагина ---
require_once SYA_PLUGIN_PATH . 'admin/meta-box.php';
require_once SYA_PLUGIN_PATH . 'admin/save-data.php';
require_once SYA_PLUGIN_PATH . 'includes/ai-handler.php';
require_once SYA_PLUGIN_PATH . 'includes/output-tags.php';
require_once SYA_PLUGIN_PATH . 'includes/settings-page.php';
require_once SYA_PLUGIN_PATH . 'includes/virtual-robots.php';
require_once SYA_PLUGIN_PATH . 'includes/sitemap-generator.php';
require_once SYA_PLUGIN_PATH . 'includes/ai-helpers.php';
require_once SYA_PLUGIN_PATH . 'includes/list-table-actions.php';
require_once SYA_PLUGIN_PATH . 'includes/cron-automation.php';

/**
 * Основная функция инициализации плагина.
 */
function sya_init() {
    add_action( 'add_meta_boxes', 'sya_add_seo_meta_box' );
    add_action( 'save_post', 'sya_save_seo_meta_data' );
    add_action( 'wp_head', 'sya_output_seo_tags', 1 );
}
add_action( 'plugins_loaded', 'sya_init' );

/**
 * Подключает CSS и JavaScript для админ-панели.
 *
 * @param string $hook Идентификатор текущей страницы в админ-панели.
 */
function sya_admin_enqueue_assets( $hook ) {
    if ( 'post.php' != $hook && 'post-new.php' != $hook ) {
        return;
    }

    // ИСПРАВЛЕНО: Добавлен сегмент /assets/ в путь к файлу стилей
    wp_enqueue_style(
        'sya-admin-styles',
        SYA_PLUGIN_URL . 'admin/assets/admin-styles.css',
        [],
        '1.0'
    );

    // ИСПРАВЛЕНО: Добавлен сегмент /assets/ в путь к файлу скриптов
    wp_enqueue_script(
        'sya-admin-scripts',
        SYA_PLUGIN_URL . 'admin/assets/admin-scripts.js',
        ['jquery'],
        '1.0',
        true
    );

    wp_localize_script( 'sya-admin-scripts', 'sya_ajax', [
        'ajax_url' => admin_url( 'admin-ajax.php' ),
        'nonce'    => wp_create_nonce( 'sya_ajax_nonce' )
    ]);
}
add_action( 'admin_enqueue_scripts', 'sya_admin_enqueue_assets' );