<?php
/**
 * Файл отвечает за создание виртуального robots.txt.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Перехватывает запрос к robots.txt.
 */
function sya_handle_virtual_robots_txt() {
    // Проверяем, включена ли опция "Публичный сайт" в настройках WordPress.
    // Если сайт закрыт от индексации, WordPress сам создает robots.txt с Disallow: /
    // и мы не должны ему мешать.
    if ( '0' == get_option( 'blog_public' ) ) {
        return;
    }

    $content = get_option( 'sya_robots_txt_content' );

    // Если у нас есть сохраненное содержимое, выводим его.
    if ( ! empty( $content ) ) {
        header( 'Content-Type: text/plain; charset=utf-8' );
        echo $content;
        die; // Важно: завершаем выполнение, чтобы WordPress не вывел ничего лишнего.
    }
}
// Цепляемся к хуку 'do_robots', который специально для этого и создан.
add_action( 'do_robots', 'sya_handle_virtual_robots_txt', 100, 0 );