<?php
/**
 * Добавляет быстрые действия (quick actions) в таблицы со списками
 * записей, страниц и товаров в админ-панели WordPress.
 */

// Прямой доступ к файлу запрещен
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Добавляет кастомную ссылку "AI: Сгенерировать SEO" к списку действий для каждой строки.
 *
 * @param array   $actions Массив существующих ссылок действий (например, 'Изменить', 'Удалить').
 * @param WP_Post $post    Объект поста для текущей строки.
 * @return array           Модифицированный массив ссылок действий.
 */
function sya_add_quick_action_link( $actions, $post ) {
    // Проверяем, есть ли у текущего пользователя права на редактирование этого поста.
    // Это важная проверка безопасности.
    if ( current_user_can( 'edit_post', $post->ID ) ) {
        
        // Добавляем наш новый элемент в массив действий.
        // Ключ 'sya_generate_seo' - это уникальный идентификатор нашего действия.
        $actions['sya_generate_seo'] = sprintf(
            // Создаем HTML-код ссылки.
            // class="sya-generate-seo-link" - для того, чтобы наш JavaScript мог ее найти.
            // data-postid - хранит ID поста, для которого нужно выполнить действие.
            // data-nonce - хранит уникальный ключ безопасности для этого конкретного действия.
            '<a href="#" class="sya-generate-seo-link" data-postid="%d" data-nonce="%s">AI: Сгенерировать SEO</a>',
            $post->ID, // Подставляем ID поста
            wp_create_nonce( 'sya_generate_seo_' . $post->ID ) // Создаем nonce
        );
    }
    
    // Возвращаем измененный массив действий.
    return $actions;
}

// Применяем нашу функцию к разным типам контента с помощью фильтров WordPress.
// Приоритет 10, 2 аргумента (стандартные значения).
add_filter( 'post_row_actions', 'sya_add_quick_action_link', 10, 2 ); // Для типа "Записи"
add_filter( 'page_row_actions', 'sya_add_quick_action_link', 10, 2 ); // Для типа "Страницы"

// Для товаров WooCommerce используется свой, отдельный хук.
add_filter( 'product_row_actions', 'sya_add_quick_action_link', 10, 2 ); // Для типа "Товары"