<?php
/**
 * Файл отвечает за сохранение SEO-данных из мета-бокса.
 */

// Прямой доступ к файлу запрещен
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Сохраняет кастомные SEO-поля при сохранении поста.
 * @param int $post_id ID поста, который сохраняется.
 */
function sya_save_seo_meta_data( $post_id ) {
    // --- 1. Проверка безопасности ---
    if ( ! isset( $_POST['sya_nonce'] ) || ! wp_verify_nonce( $_POST['sya_nonce'], 'sya_save_action' ) ) {
        return;
    }
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    // --- 2. Определение полей для сохранения ---
    $fields_to_save = [
        '_sya_seo_title'        => 'sya_seo_title',
        '_sya_meta_description' => 'sya_meta_description',
        '_sya_focus_keywords'   => 'sya_focus_keywords',
        '_sya_is_turbo_enabled' => 'sya_is_turbo_enabled',
        '_sya_og_title'         => 'sya_og_title',
        '_sya_og_description'   => 'sya_og_description',
        '_sya_og_image_id'      => 'sya_og_image_id',
        '_sya_schema_type'      => 'sya_schema_type',
        '_sya_schema_faq_data'  => 'sya_schema_faq_data',
    ];

    // --- 3. Сохранение данных в базу данных ---
    foreach ( $fields_to_save as $meta_key => $post_key ) {
        if ( isset( $_POST[$post_key] ) ) {
            $value = $_POST[$post_key];
            
            // Определяем тип очистки в зависимости от поля
            if ( $post_key === 'sya_meta_description' || $post_key === 'sya_og_description' || $post_key === 'sya_schema_faq_data' ) {
                $sanitized_value = sanitize_textarea_field( $value );
            } elseif ($post_key === 'sya_og_image_id') {
                $sanitized_value = intval( $value );
            } else {
                $sanitized_value = sanitize_text_field( $value );
            }
            
            // Сохраняем, только если есть значение, или удаляем, если пусто
            if ($sanitized_value) {
                 update_post_meta( $post_id, $meta_key, $sanitized_value );
            } else {
                 delete_post_meta( $post_id, $meta_key );
            }

        } else {
            // Если поле не было отправлено (например, сняли галочку), удаляем его
            delete_post_meta( $post_id, $meta_key );
        }
    }
}