jQuery(document).ready(function($) {

    // --- 1. ИНИЦИАЛИЗАЦИЯ ПЕРЕМЕННЫХ ---
    const titleInput = $('#sya_seo_title');
    const descInput = $('#sya_meta_description');
    const keywordsInput = $('#sya_focus_keywords');
    const postId = $('#post_ID').val();

    const snippetTitle = $('#sya-snippet-preview .sya-preview-title');
    const snippetDesc = $('#sya-snippet-preview .sya-preview-desc');

    const titleCounter = $('#sya-title-counter');
    const descCounter = $('#sya-desc-counter');
    const titleProgressBar = $('#sya-title-progress');
    const descProgressBar = $('#sya-desc-progress');
    
    const generateBtn = $('#sya-generate-ai');
    const analyzeBtn = $('#sya-analyze-content');
    const spinner = $('#sya-spinner');
    const aiStatusBox = $('#sya-ai-status');

    // --- 2. ЛОГИКА РАБОТЫ ВКЛАДОК ---
    $('.sya-tabs').on('click', '.sya-tab-link', function(e) {
        e.preventDefault();
        const targetTab = $(this).attr('href');
        $('.sya-tab-link').removeClass('active');
        $('.sya-tab-content').removeClass('active');
        $(this).addClass('active');
        $(targetTab).addClass('active');
    });

    // --- 3. ОБНОВЛЕНИЕ СНИППЕТА И СЧЕТЧИКОВ ---
    function updateSnippetAndCounters() {
        const titleText = titleInput.val() || "Ваш SEO-заголовок";
        snippetTitle.text(titleText);
        const titleLength = titleText.length;
        titleCounter.text(titleLength);
        updateProgressBar(titleProgressBar, titleLength, 70, 50);

        const descText = descInput.val() || "Здесь будет ваше мета-описание...";
        snippetDesc.text(descText);
        const descLength = descText.length;
        descCounter.text(descLength);
        updateProgressBar(descProgressBar, descLength, 200, 150);
    }

    function updateProgressBar(progressBar, current, max, optimal) {
        const percentage = (current / optimal) * 100;
        let color = '#4CAF50';
        if (current === 0 || current > max) { color = '#F44336'; } 
        else if (current < optimal * 0.9 || current > optimal * 1.1) { color = '#FFC107'; }
        progressBar.css({ 'width': Math.min(percentage, 100) + '%', 'background-color': color });
    }

    updateSnippetAndCounters();
    titleInput.on('keyup input', updateSnippetAndCounters);
    descInput.on('keyup input', updateSnippetAndCounters);
    
    // --- 4. ЛОГИКА РАБОТЫ С AI ---
    
    // Кнопка "Сгенерировать SEO-данные"
    generateBtn.on('click', function() {
        generateBtn.prop('disabled', true);
        analyzeBtn.prop('disabled', true);
        spinner.addClass('is-active');
        aiStatusBox.html('<p>Генерирую SEO-заголовок и описание...</p>').removeClass('error success');

        $.post(sya_ajax.ajax_url, {
            action: 'sya_get_suggestions_for_metabox', // Наш новый AJAX action
            nonce: sya_ajax.nonce,
            post_id: postId
        })
        .done(function(response) {
            if (response.success) {
                // Вставляем полученные данные в поля на первой вкладке
                titleInput.val(response.data.seo_title);
                descInput.val(response.data.meta_description);
                // Обновляем превью и счетчики
                updateSnippetAndCounters();
                aiStatusBox.html('<p><strong>Готово!</strong> SEO-данные вставлены в поля. Не забудьте сохранить запись.</p>').addClass('success');
            } else {
                aiStatusBox.html(`<p><strong>Ошибка:</strong> ${response.data.message}</p>`).addClass('error');
            }
        })
        .fail(function() {
            aiStatusBox.html('<p><strong>Сетевая ошибка:</strong> Не удалось связаться с сервером.</p>').addClass('error');
        })
        .always(function() {
            generateBtn.prop('disabled', false);
            analyzeBtn.prop('disabled', false);
            spinner.removeClass('is-active');
        });
    });

    // Кнопка "Провести углубленный анализ"
    analyzeBtn.on('click', function() {
        const keywords = keywordsInput.val();
        if (!keywords) {
            alert('Пожалуйста, введите фокусные ключевые слова для анализа.');
            return;
        }

        generateBtn.prop('disabled', true);
        analyzeBtn.prop('disabled', true);
        spinner.addClass('is-active');
        aiStatusBox.html('<p>Отправляю запрос к AI для углубленного анализа...</p>').removeClass('error success');
        
        $.post(sya_ajax.ajax_url, {
            action: 'sya_get_ai_suggestions',
            nonce: sya_ajax.nonce,
            post_id: postId,
            keywords: keywords
        })
        .done(function(response) {
            if (response.success) {
                const data = response.data;
                let analysisHtml = '<h4>Результаты углубленного анализа:</h4>';
                
                if (data.content_score) {
                    analysisHtml += '<h5>Оценки контента (0-100):</h5><ul>';
                    analysisHtml += `<li><strong>Ясность изложения:</strong> ${data.content_score.clarity}</li>`;
                    analysisHtml += `<li><strong>Полнота раскрытия темы:</strong> ${data.content_score.completeness}</li>`;
                    analysisHtml += `<li><strong>Коммерческая убедительность:</strong> ${data.content_score.commercial_intent}</li>`;
                    analysisHtml += '</ul>';
                }
                if (data.lsi_suggestions && data.lsi_suggestions.missing_keywords) {
                    analysisHtml += '<h5>Рекомендуемые LSI-фразы для добавления:</h5>';
                    analysisHtml += `<p class="description">${data.lsi_suggestions.explanation}</p>`;
                    analysisHtml += '<div class="sya-lsi-tags">';
                    data.lsi_suggestions.missing_keywords.forEach(function(keyword) {
                        analysisHtml += `<span class="sya-lsi-tag">${keyword}</span>`;
                    });
                    analysisHtml += '</div>';
                }
                if (data.actionable_recommendations) {
                    analysisHtml += '<h5>Конкретные шаги по улучшению:</h5><ol>';
                    data.actionable_recommendations.forEach(function(rec) {
                        analysisHtml += `<li>${rec}</li>`;
                    });
                    analysisHtml += '</ol>';
                }
                aiStatusBox.html(analysisHtml).addClass('success');
                
            } else {
                aiStatusBox.html(`<p><strong>Ошибка:</strong> ${response.data.message}</p>`).addClass('error');
            }
        })
        .fail(function() {
            aiStatusBox.html('<p><strong>Сетевая ошибка:</strong> Не удалось связаться с сервером.</p>').addClass('error');
        })
        .always(function() {
            generateBtn.prop('disabled', false);
            analyzeBtn.prop('disabled', false);
            spinner.removeClass('is-active');
        });
    });

    // --- 5. ЛОГИКА ЗАГРУЗЧИКА OPEN GRAPH ИЗОБРАЖЕНИЙ ---
    let mediaUploader;
    $('#sya_upload_og_image_button').on('click', function(e) {
        e.preventDefault();
        if (mediaUploader) { mediaUploader.open(); return; }
        mediaUploader = wp.media({
            title: 'Выберите изображение для Open Graph',
            button: { text: 'Использовать это изображение' },
            multiple: false
        });
        mediaUploader.on('select', function() {
            const attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#sya_og_image_id').val(attachment.id);
            $('.sya-image-preview').html('<img src="' + attachment.sizes.large.url + '" alt="Preview" style="max-width:300px; height:auto;">');
            $('#sya_remove_og_image_button').show();
        });
        mediaUploader.open();
    });

    $('#sya_remove_og_image_button').on('click', function(e) {
        e.preventDefault();
        $('#sya_og_image_id').val('');
        $('.sya-image-preview').html('');
        $(this).hide();
    });

    // --- 6. ЛОГИКА ДЛЯ ДИНАМИЧЕСКИХ ПОЛЕЙ SCHEMA ---
    const schemaTypeSelector = $('#sya_schema_type');
    const faqFieldsContainer = $('#sya-faq-fields');
    function toggleSchemaFields() {
        const selectedType = schemaTypeSelector.val();
        $('.sya-schema-fields-container').hide();
        if (selectedType === 'FAQPage') { faqFieldsContainer.show(); }
    }
    toggleSchemaFields(); 
    schemaTypeSelector.on('change', toggleSchemaFields);

    // --- 7. ЛОГИКА ДЛЯ "ОДНОКЛИКОВОЙ" SEO-ГЕНЕРАЦИИ В СПИСКЕ ---
    $('body').on('click', '.sya-generate-seo-link', function(e) {
        e.preventDefault();
        const link = $(this);
        const postId = link.data('postid');
        const nonce = link.data('nonce');
        const row = link.closest('tr');

        link.html('Генерация...');
        row.css('opacity', '0.6');

        $.post(ajaxurl, {
            action: 'sya_generate_single_seo',
            post_id: postId,
            nonce: nonce
        })
        .done(function(response) {
            if (response.success) {
                link.html('✔ Готово!');
                row.find('.row-title').prepend('<span class="dashicons dashicons-yes-alt" style="color: #4CAF50; margin-right: 5px;"></span> ');
            } else {
                link.html('✖ Ошибка!');
                alert('Ошибка: ' + response.data.message);
            }
        })
        .fail(function() {
            link.html('✖ Ошибка сети!');
            alert('Сетевая ошибка. Не удалось выполнить запрос.');
        })
        .always(function() {
            row.css('opacity', '1');
        });
    });
});